/*
 * Decompiled with CFR 0.152.
 */
package tmcm.xSortLab;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import tmcm.xSortLab.LogPanel;
import tmcm.xSortLab.MessageCanvas;
import tmcm.xSortLab.SortCanvas;

class VisualSortPanel
extends Panel {
    static final String[] sortName = new String[]{"Bubble Sort", "Selection Sort", "Insertion Sort", "Merge Sort", "QuickSort"};
    Choice sortMethodChoice;
    int currentSortMethod = 0;
    Checkbox fastBox;
    Button goButton;
    Button stepButton;
    Button newButton;
    Label comparisons;
    Label copies;
    SortCanvas sorter;
    MessageCanvas comment1;
    MessageCanvas comment2;
    Panel messagePanel;
    Panel controlPanel;
    Panel statPanel;
    LogPanel log;

    VisualSortPanel(LogPanel logPanel) {
        this.log = logPanel;
        this.setBackground(Color.lightGray);
        this.setLayout(null);
        this.messagePanel = new Panel();
        this.messagePanel.setBackground(Color.lightGray);
        this.messagePanel.setLayout(new GridLayout(2, 1, 5, 5));
        this.add(this.messagePanel);
        this.comment1 = new MessageCanvas("Click \"Go\" or \"Step\" to begin sorting.");
        this.comment1.setBackground(Color.white);
        this.comment1.setForeground(Color.red);
        this.messagePanel.add(this.comment1);
        this.comment2 = new MessageCanvas();
        this.comment2.setBackground(Color.white);
        this.comment2.setForeground(Color.red);
        this.messagePanel.add(this.comment2);
        this.controlPanel = new Panel();
        this.controlPanel.setLayout(new GridLayout(5, 1, 3, 3));
        this.add(this.controlPanel);
        this.sortMethodChoice = new Choice();
        for (int i = 0; i < sortName.length; ++i) {
            this.sortMethodChoice.addItem(sortName[i]);
        }
        this.controlPanel.add(this.sortMethodChoice);
        this.fastBox = new Checkbox("Fast");
        Panel panel = new Panel();
        panel.add(this.fastBox);
        this.controlPanel.add(panel);
        this.goButton = new Button("Go");
        this.controlPanel.add(this.goButton);
        this.stepButton = new Button("Step");
        this.controlPanel.add(this.stepButton);
        this.newButton = new Button("Start Again");
        this.controlPanel.add(this.newButton);
        this.statPanel = new Panel();
        this.statPanel.setLayout(new GridLayout(4, 1, 5, 5));
        this.statPanel.setBackground(Color.white);
        this.add(this.statPanel);
        this.statPanel.add(new Label("  Comparisons:"));
        this.comparisons = new Label("0", 1);
        this.comparisons.setForeground(Color.red);
        this.statPanel.add(this.comparisons);
        this.statPanel.add(new Label("  Copies:"));
        this.copies = new Label("0", 1);
        this.copies.setForeground(Color.red);
        this.statPanel.add(this.copies);
        this.sorter = new SortCanvas(this, this.comparisons, this.copies, this.comment1, this.comment2);
        this.add(this.sorter);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (n3 < 300) {
            n3 = 300;
        }
        if (n4 < 200) {
            n4 = 200;
        }
        this.messagePanel.reshape(0, n4 - 45, n3, 45);
        this.sorter.reshape(0, 0, n3 - 125, n4 - 50);
        int n5 = (n4 - 55) * 5 / 9;
        this.controlPanel.reshape(n3 - 120, 0, 120, n5);
        this.statPanel.reshape(n3 - 120, n5 + 5, 120, n4 - 55 - n5);
    }

    void aboutToShow() {
        this.goButton.setLabel("Go");
        this.stepButton.enable();
        this.sorter.newSort(this.currentSortMethod + 1);
    }

    void aboutToHide() {
        this.sorter.stopRunning();
    }

    void doneRunning(int n, int n2, int n3) {
        this.goButton.enable();
        this.goButton.setLabel("Go");
        this.stepButton.disable();
        this.log.addLine(sortName[n - 1] + " applied to 1 array containing 16 items:");
        this.log.addLine("   Number of comparisons: " + n2);
        this.log.addLine("   Number of copies: " + n3);
        this.log.addEoln();
    }

    void runnerStopped() {
        this.goButton.enable();
        this.goButton.setLabel("Go");
        this.stepButton.enable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean action(Event event, Object object) {
        if (event.target == this.sortMethodChoice) {
            int n = this.sortMethodChoice.getSelectedIndex();
            if (n == this.currentSortMethod) {
                return true;
            }
            this.currentSortMethod = n;
            this.sorter.newSort(this.currentSortMethod + 1);
            return true;
        }
        if (event.target == this.fastBox) {
            this.sorter.setFast((Boolean)object);
            return true;
        }
        if (event.target == this.goButton) {
            SortCanvas sortCanvas = this.sorter;
            synchronized (sortCanvas) {
                if (this.sorter.getState() == 4) {
                    this.goButton.disable();
                    this.sorter.stopRunning();
                } else {
                    this.goButton.setLabel("Stop");
                    this.stepButton.disable();
                    this.sorter.startRunning();
                }
            }
            return true;
        }
        if (event.target == this.stepButton) {
            this.sorter.doStep();
            SortCanvas sortCanvas = this.sorter;
            synchronized (sortCanvas) {
                int n = this.sorter.getState();
                if (n == 3) {
                    this.stepButton.disable();
                    this.goButton.disable();
                }
            }
            return true;
        }
        if (event.target == this.newButton) {
            this.sorter.newSort(this.currentSortMethod + 1);
            this.goButton.setLabel("Go");
            this.stepButton.enable();
            return true;
        }
        return super.action(event, object);
    }
}

