/*
 * Decompiled with CFR 0.152.
 */
package tmcm.xSortLab;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Event;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import tmcm.xSortLab.LogPanel;
import tmcm.xSortLab.TimedSort;

class TimedSortPanel
extends Panel {
    static final String[] sortName = new String[]{"Bubble Sort", "Selection Sort", "Insertion Sort", "Merge Sort", "QuickSort"};
    Choice methodChoice;
    Button goButton;
    TextField arrayCountInput;
    TextField arraySizeInput;
    boolean running;
    TimedSort sorter;

    TimedSortPanel(LogPanel logPanel) {
        this.setLayout(new BorderLayout(5, 5));
        this.sorter = new TimedSort(this, logPanel);
        this.add("Center", this.sorter);
        Panel panel = new Panel();
        this.methodChoice = new Choice();
        for (int i = 0; i < sortName.length; ++i) {
            this.methodChoice.addItem(sortName[i]);
        }
        panel.add(this.methodChoice);
        this.goButton = new Button("Start Sorting");
        panel.add(this.goButton);
        this.add("South", panel);
        Panel panel2 = new Panel();
        panel2.add(new Label("Array size:"));
        this.arraySizeInput = new TextField("1000", 6);
        panel2.add(this.arraySizeInput);
        panel2.add(new Label("    Number of arrays:"));
        this.arrayCountInput = new TextField("1", 6);
        panel2.add(this.arrayCountInput);
        this.add("North", panel2);
    }

    void aboutToShow() {
        this.sorter.sortMethod = -1;
        this.goButton.setLabel("Start Sorting");
        this.goButton.enable();
        this.arraySizeInput.requestFocus();
        this.running = false;
    }

    void aboutToHide() {
        if (this.sorter.getState() == 2) {
            this.sorter.setState(3);
        }
    }

    void doneRunning() {
        this.goButton.setLabel("Start Sorting");
        this.goButton.enable();
        this.arraySizeInput.requestFocus();
        this.running = false;
    }

    void readyToStart() {
        this.goButton.enable();
    }

    void startSorter() {
        int n = this.methodChoice.getSelectedIndex();
        int n2 = 0;
        int n3 = 0;
        String string = this.arraySizeInput.getText();
        if (string == null || string.trim().length() == 0) {
            this.sorter.setError("Please enter an array size!");
            this.arraySizeInput.requestFocus();
            return;
        }
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.sorter.setError("The array size must be an integer!");
            this.arraySizeInput.requestFocus();
            return;
        }
        if (n3 <= 0) {
            if (n3 == 0) {
                this.sorter.setError("The array size can't be zero!");
            } else {
                this.sorter.setError("The array size can't be negative!");
            }
            this.arraySizeInput.requestFocus();
            return;
        }
        string = this.arrayCountInput.getText();
        if (string == null || string.trim().length() == 0) {
            n2 = 1;
        } else {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.sorter.setError("The number of arrays must be an integer!");
                this.arrayCountInput.requestFocus();
                return;
            }
            if (n2 <= 0) {
                if (n2 == 0) {
                    this.sorter.setError("The number of arrays can't be zero!");
                } else {
                    this.sorter.setError("The number of arrays can't be negative!");
                }
                this.arrayCountInput.requestFocus();
                return;
            }
        }
        if (n3 > 10000000 || n2 > 10000000 || (long)n3 * (long)n2 > 10000000L) {
            this.sorter.setError("No more than ten million items, total, please!");
            this.arraySizeInput.requestFocus();
            return;
        }
        this.running = true;
        this.goButton.disable();
        this.goButton.setLabel("Abort");
        this.sorter.start(n, n3, n2);
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.goButton) {
            if (this.running) {
                this.goButton.disable();
                this.sorter.setState(3);
            } else {
                this.startSorter();
            }
            return true;
        }
        return super.action(event, object);
    }
}

