/*
 * Decompiled with CFR 0.152.
 */
package tmcm.xSortLab;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Random;
import tmcm.xSortLab.LogPanel;
import tmcm.xSortLab.SortAbort;
import tmcm.xSortLab.TimedSortPanel;

final class TimedSort
extends Canvas
implements Runnable {
    static final int computeInterval = 400;
    static final int pauseInterval = 100;
    static final int IDLE = 0;
    static final int RUN = 2;
    static final int ABORT = 3;
    static final int ERROR = 4;
    static final int APPLETSTOPPED = 5;
    int state = 0;
    int saveState = 0;
    String errorMessage;
    static final Color backgroundColor = new Color(230, 255, 230);
    static final Color borderColor;
    static final Color labelColor;
    static final Color statsColor;
    static final String[] dataLabel;
    TimedSortPanel owner;
    LogPanel log;
    int[] A;
    int[] B;
    Random rand = new Random();
    int sortMethod;
    int arraySize;
    int arrayCt;
    long comparisonCt;
    long copyCt;
    int arraysSorted;
    long comparisonsSinceLastCheck;
    long startTime;
    long lastPauseTime;
    long totalPausedTime;
    long elapsedTimeForDisplay;
    long computeTimeForDisplay;
    long comparisonCtForDisplay;
    long copyCtForDisplay;
    int arraysSortedForDisplay;
    int width = -1;
    int height;
    Font font;
    FontMetrics fm;
    Thread runner;

    TimedSort(TimedSortPanel timedSortPanel, LogPanel logPanel) {
        this.owner = timedSortPanel;
        this.log = logPanel;
        this.setBackground(backgroundColor);
        this.sortMethod = -1;
    }

    public synchronized void paint(Graphics graphics) {
        if (this.size().width != this.width || this.size().height != this.height || this.font == null) {
            this.width = this.size().width;
            this.height = this.size().height;
            this.font = new Font("TimesRoman", 0, 18);
            this.fm = graphics.getFontMetrics(this.font);
            if (this.fm.stringWidth("Approximate Compute Time: ") > this.width / 2 || this.fm.getHeight() * 8 > this.height) {
                this.font = new Font("TimesRoman", 0, 14);
                this.fm = graphics.getFontMetrics(this.font);
                if (this.fm.stringWidth("Approximate Compute Time: ") > this.width / 2 || this.fm.getHeight() * 8 > this.height) {
                    this.font = new Font("TimesRoman", 0, 12);
                    this.fm = graphics.getFontMetrics(this.font);
                    if (this.fm.stringWidth("Approximate Compute Time: ") > this.width / 2 || this.fm.getHeight() * 8 > this.height) {
                        this.font = new Font("TimesRoman", 0, 10);
                        this.fm = graphics.getFontMetrics(this.font);
                    }
                }
            }
        }
        graphics.setFont(this.font);
        graphics.setColor(borderColor);
        graphics.drawRect(0, 0, this.width, this.height);
        graphics.drawRect(1, 1, this.width - 2, this.height - 2);
        graphics.drawLine(this.width - 2, 0, this.width - 2, this.height);
        graphics.drawLine(0, this.height - 2, this.width, this.height - 2);
        if (this.state == 3) {
            int n = this.fm.stringWidth("OPERATION ABORTED.");
            graphics.setColor(statsColor);
            graphics.drawString("OPERATION ABORTED", (this.width - n) / 2, this.height / 2);
        } else if (this.state == 4) {
            int n = this.fm.stringWidth(this.errorMessage);
            graphics.setColor(statsColor);
            graphics.drawString(this.errorMessage, (this.width - n) / 2, this.height / 2);
        } else if (this.sortMethod == -1) {
            graphics.setColor(labelColor);
            int n = this.fm.getHeight();
            graphics.drawString("Enter the array size and number of arrays.", n, 2 * n);
            graphics.drawString("Select a sort method.", n, 3 * n);
            graphics.drawString("Click \"Start Sorting\" to begin.", n, 4 * n);
        } else {
            int n;
            int n2 = this.fm.getHeight();
            int n3 = (this.height - 7 * n2 + this.fm.getLeading()) / 2 + this.fm.getAscent();
            Rectangle rectangle = graphics.getClipRect();
            if (rectangle.x < this.width / 2) {
                graphics.setColor(labelColor);
                for (n = 0; n < 7; ++n) {
                    int n4 = this.fm.stringWidth(dataLabel[n]);
                    graphics.drawString(dataLabel[n], this.width / 2 - n4, n3 + n2 * n);
                }
                if (this.getState() == 0) {
                    graphics.setColor(statsColor);
                    graphics.drawString("DONE!", 10, this.fm.getAscent() + 10);
                }
            }
            if (rectangle.x + rectangle.width > this.width / 2) {
                graphics.setColor(statsColor);
                n = this.width / 2 + 4;
                graphics.drawString(TimedSortPanel.sortName[this.sortMethod], n, n3);
                graphics.drawString("" + this.arraySize, n, n3 + n2);
                graphics.drawString("" + this.arraysSortedForDisplay + " of " + this.arrayCt, n, n3 + 2 * n2);
                graphics.drawString("" + this.divideBy1000(this.elapsedTimeForDisplay) + " seconds", n, n3 + 3 * n2);
                graphics.drawString("" + this.divideBy1000(this.computeTimeForDisplay) + " seconds", n, n3 + 4 * n2);
                graphics.drawString("" + this.comparisonCtForDisplay, n, n3 + 5 * n2);
                graphics.drawString("" + this.copyCtForDisplay, n, n3 + 6 * n2);
            }
        }
    }

    String divideBy1000(long l) {
        if (l == 0L) {
            return "0";
        }
        long l2 = l / 1000L;
        long l3 = l - 1000L * l2;
        if (l3 > 99L) {
            return "" + l2 + '.' + l3;
        }
        if (l3 > 9L) {
            return "" + l2 + ".0" + l3;
        }
        return "" + l2 + ".00" + l3;
    }

    synchronized void doAppletStop() {
        this.saveState = this.state;
        this.state = 5;
        if (this.saveState == 2) {
            this.notify();
        }
    }

    synchronized void doAppletStart() {
        this.state = this.saveState;
        if (this.state == 2) {
            this.notify();
        }
    }

    synchronized void report(long l, long l2, long l3, long l4, int n) {
        this.elapsedTimeForDisplay = l;
        this.computeTimeForDisplay = l2;
        this.comparisonCtForDisplay = l3;
        this.copyCtForDisplay = l4;
        this.arraysSortedForDisplay = n;
    }

    synchronized void start(int n, int n2, int n3) {
        if (this.state == 2) {
            return;
        }
        this.state = 2;
        this.sortMethod = n;
        this.arraySize = n2;
        this.arrayCt = n3;
        this.report(0L, 0L, 0L, 0L, 0);
        this.repaint();
        if (this.runner == null || !this.runner.isAlive()) {
            this.runner = new Thread(this);
            this.runner.start();
        }
        this.notify();
    }

    synchronized void setState(int n) {
        this.state = n;
        this.notify();
    }

    synchronized int getState() {
        return this.state;
    }

    synchronized void setError(String string) {
        this.state = 4;
        this.errorMessage = string;
        this.repaint();
    }

    synchronized void doWait(int n) {
        try {
            this.wait(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean compare(boolean bl) {
        ++this.comparisonCt;
        ++this.comparisonsSinceLastCheck;
        if (this.comparisonsSinceLastCheck == 10000L) {
            this.comparisonsSinceLastCheck = 0L;
            long l = System.currentTimeMillis();
            int n = this.getState();
            if (n == 3) {
                throw new SortAbort();
            }
            if (n == 5) {
                TimedSort timedSort = this;
                synchronized (timedSort) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                long l2 = System.currentTimeMillis();
                this.totalPausedTime += l2 - l;
                this.lastPauseTime = l2;
            } else if (l - this.lastPauseTime >= 400L) {
                this.report(l - this.startTime, l - this.startTime - this.totalPausedTime, this.comparisonCt, this.copyCt, this.arraysSorted);
                this.repaint(this.size().width / 2 + 1, 4, this.size().width / 2 - 5, this.size().height - 8);
                this.doWait(100);
                if (this.getState() == 3) {
                    throw new SortAbort();
                }
                long l3 = System.currentTimeMillis();
                this.totalPausedTime += l3 - l;
                this.lastPauseTime = l3;
            }
        }
        return bl;
    }

    void swap(int n, int n2) {
        int n3 = this.A[n];
        this.A[n] = this.A[n2];
        this.A[n2] = n3;
        this.copyCt += 3L;
    }

    void bubbleSort(int n, int n2) {
        for (int i = n2; i > n; --i) {
            for (int j = n; j < i; ++j) {
                if (!this.compare(this.A[j] > this.A[j + 1])) continue;
                this.swap(j, j + 1);
            }
        }
    }

    void selectionSort(int n, int n2) {
        for (int i = n2; i > n; --i) {
            int n3 = n;
            for (int j = n + 1; j <= i; ++j) {
                if (!this.compare(this.A[j] > this.A[n3])) continue;
                n3 = j;
            }
            this.swap(n3, i);
        }
    }

    void insertionSort(int n, int n2) {
        for (int i = n + 1; i <= n2; ++i) {
            int n3 = this.A[i];
            ++this.copyCt;
            for (int j = i - 1; j >= n && this.compare(this.A[j] > n3); --j) {
                this.A[j + 1] = this.A[j];
                ++this.copyCt;
            }
            this.A[j + 1] = n3;
            ++this.copyCt;
        }
    }

    void doMerge(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < n5; ++i) {
            this.B[n6++] = n3 > n4 ? this.A[n++] : (n > n2 ? this.A[n3++] : (this.compare(this.A[n] < this.A[n3]) ? this.A[n++] : this.A[n3++]));
            ++this.copyCt;
        }
    }

    void mergeSort(int n, int n2) {
        int n3 = n2 - n + 1;
        for (int i = 1; i < n3; i *= 2) {
            int n4;
            int n5 = n;
            while (n5 <= n2) {
                n4 = n5 + i;
                int n6 = n4 - 1;
                int n7 = n4 + i - 1;
                if (n6 >= n2) {
                    this.doMerge(n5, n2, 0, -1, n2 - n5 + 1, n5 - n);
                } else if (n7 >= n2) {
                    this.doMerge(n5, n6, n4, n2, n2 - n5 + 1, n5 - n);
                } else {
                    this.doMerge(n5, n6, n4, n7, 2 * i, n5 - n);
                }
                n5 = n7 + 1;
            }
            for (n4 = 0; n4 < n3; ++n4) {
                this.A[n + n4] = this.B[n4];
            }
            this.copyCt += (long)n3;
        }
    }

    int quickSortStep(int n, int n2) {
        int n3 = this.A[n2];
        ++this.copyCt;
        while (n2 > n) {
            while (n2 > n && this.compare(this.A[n] <= n3)) {
                ++n;
            }
            if (n2 <= n) continue;
            this.A[n2] = this.A[n];
            ++this.copyCt;
            --n2;
            while (n2 > n && this.compare(this.A[n2] >= n3)) {
                --n2;
            }
            if (n2 <= n) continue;
            this.A[n] = this.A[n2];
            ++this.copyCt;
            ++n;
        }
        this.A[n2] = n3;
        ++this.copyCt;
        return n2;
    }

    void quickSort(int n, int n2) {
        if (n2 > n) {
            int n3 = this.quickSortStep(n, n2);
            if (n3 - n > n2 - n3) {
                this.quickSort(n3 + 1, n2);
                this.quickSort(n, n3 - 1);
            } else {
                this.quickSort(n, n3 - 1);
                this.quickSort(n3 + 1, n2);
            }
        }
    }

    void doSort() {
        int n;
        int n2 = this.arraySize * this.arrayCt;
        this.A = new int[n2];
        if (this.sortMethod == 3) {
            this.B = new int[this.arraySize];
        }
        for (n = 0; n < n2; ++n) {
            this.A[n] = Math.abs(this.rand.nextInt());
        }
        System.gc();
        this.owner.readyToStart();
        this.doWait(100);
        if (this.getState() == 3) {
            throw new SortAbort();
        }
        this.comparisonsSinceLastCheck = 0L;
        this.copyCt = 0L;
        this.comparisonCt = 0L;
        this.totalPausedTime = 0L;
        this.lastPauseTime = this.startTime = System.currentTimeMillis();
        this.arraysSorted = 0;
        n = 0;
        int n3 = this.arraySize - 1;
        switch (this.sortMethod) {
            case 0: {
                while (n < n2) {
                    this.bubbleSort(n, n3);
                    n = n3 + 1;
                    n3 += this.arraySize;
                    ++this.arraysSorted;
                }
                break;
            }
            case 1: {
                while (n < n2) {
                    this.selectionSort(n, n3);
                    n = n3 + 1;
                    n3 += this.arraySize;
                    ++this.arraysSorted;
                }
                break;
            }
            case 2: {
                while (n < n2) {
                    this.insertionSort(n, n3);
                    n = n3 + 1;
                    n3 += this.arraySize;
                    ++this.arraysSorted;
                }
                break;
            }
            case 3: {
                while (n < n2) {
                    this.mergeSort(n, n3);
                    n = n3 + 1;
                    n3 += this.arraySize;
                    ++this.arraysSorted;
                }
                break;
            }
            case 4: {
                while (n < n2) {
                    this.quickSort(n, n3);
                    n = n3 + 1;
                    n3 += this.arraySize;
                    ++this.arraysSorted;
                }
                break;
            }
        }
        long l = System.currentTimeMillis();
        this.report(l - this.startTime, l - this.startTime - this.totalPausedTime, this.comparisonCt, this.copyCt, this.arraysSorted);
        if (this.arrayCt == 1) {
            this.log.addLine(TimedSortPanel.sortName[this.sortMethod] + " applied to 1 array containing " + this.arraySize + " items:");
        } else {
            this.log.addLine(TimedSortPanel.sortName[this.sortMethod] + " applied to " + this.arrayCt + " arrays, each containing " + this.arraySize + " items:");
        }
        this.log.addLine("   Elapsed Time: " + this.divideBy1000(l - this.startTime) + " seconds");
        this.log.addLine("   Approximate Compute Time: " + this.divideBy1000(l - this.startTime - this.totalPausedTime) + " seconds");
        this.log.addLine("   Number of comparisons: " + this.comparisonCt);
        this.log.addLine("   Number of copies: " + this.copyCt);
        this.log.addEoln();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            TimedSort timedSort = this;
            synchronized (timedSort) {
                while (this.state != 2) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.state == 3) {
                    this.repaint();
                    this.owner.doneRunning();
                    continue;
                }
            }
            try {
                this.doSort();
                this.setState(0);
                this.repaint();
            }
            catch (SortAbort sortAbort) {
                this.repaint();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.setError("Not Enough Memory; use smaller or fewer arrays.");
            }
            catch (RuntimeException runtimeException) {
                this.setError("Sorry, an unexpected error occurred!");
            }
            this.B = null;
            this.A = null;
            this.owner.doneRunning();
        }
    }

    static {
        labelColor = borderColor = new Color(0, 127, 0);
        statsColor = Color.red;
        dataLabel = new String[]{"Sort Method: ", "Items per Array: ", "Arrays Sorted: ", "Elapsed Time: ", "Approximate Compute Time: ", "Comparisons: ", "Copies: "};
    }
}

