/*
 * Decompiled with CFR 0.152.
 */
package tmcm.xSortLab;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Point;
import tmcm.xSortLab.MessageCanvas;
import tmcm.xSortLab.VisualSortPanel;

class SortCanvas
extends Canvas
implements Runnable {
    Thread runner;
    static final int APPLETSTOPPED = -1;
    static final int IDLE = 0;
    static final int STARTING = 1;
    static final int STOPPED = 2;
    static final int STEP = 3;
    static final int RUN = 4;
    static final int STOPPING = 5;
    private int state = 1;
    private int oldState = 1;
    Image OSC;
    Graphics OSG;
    boolean changed;
    int changed_x;
    int changed_y;
    int changed_width;
    int changed_height;
    int width = -1;
    int height;
    static final Color backgroundColor = new Color(230, 230, 255);
    static final Color borderColor = Color.blue;
    static final Color barColor = Color.gray;
    static final Color finishedBarColor = Color.black;
    static final Color movingBarColor = Color.lightGray;
    static final Color movingBarOutlineColor = Color.gray;
    static final Color boxColor = Color.magenta;
    static final Color multiBoxColor = new Color(0, 200, 0);
    static final Color maxColor = Color.red;
    int[] item = new int[33];
    boolean tempOn;
    int[] mergeBox = new int[3];
    Point multiBoxLoc = new Point(-1, -1);
    Point movingItemLoc = new Point(-1, -1);
    int maxLoc;
    int hiLoc;
    int loLoc;
    int box1Loc;
    int box2Loc;
    int movingItem;
    int copyCt;
    int comparisonCt;
    Label comparisons;
    Label copies;
    MessageCanvas comment1;
    MessageCanvas comment2;
    VisualSortPanel owner;
    static final int barGap = 8;
    int barWidth;
    int barHeight;
    int minBarHeight;
    int barIncrement;
    int leftOffset;
    int firstRow_y;
    int secondRow_y;
    int textAscent;
    Font font;
    FontMetrics fm;
    boolean fast;
    int method = 1;
    boolean done;
    int i;
    int j;
    int k;
    int hi;
    int lo;
    int[] stack = new int[33];
    int top;
    int sortLength;
    int end_i;
    int end_j;
    boolean valid = false;

    SortCanvas(VisualSortPanel visualSortPanel, Label label, Label label2, MessageCanvas messageCanvas, MessageCanvas messageCanvas2) {
        this.owner = visualSortPanel;
        this.comparisons = label;
        this.copies = label2;
        this.comment1 = messageCanvas;
        this.comment2 = messageCanvas2;
        this.setUpSortData();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (n3 != this.width || n4 != this.height) {
            this.OSC = null;
            this.OSG = null;
        }
    }

    synchronized int getState() {
        return this.state;
    }

    synchronized void setState(int n) {
        this.state = n;
        this.notify();
    }

    void setUpSortData() {
        int n;
        this.maxLoc = -1;
        this.hiLoc = -1;
        this.loLoc = -1;
        this.box1Loc = -1;
        this.box2Loc = -1;
        this.multiBoxLoc.x = -1;
        this.mergeBox[0] = -1;
        this.movingItem = -1;
        this.tempOn = false;
        for (n = 1; n <= 16; ++n) {
            this.item[n] = n;
        }
        for (n = 16; n >= 2; --n) {
            int n2 = 1 + (int)(Math.random() * (double)n);
            int n3 = this.item[n];
            this.item[n] = this.item[n2];
            this.item[n2] = n3;
        }
        this.item[0] = -1;
        for (n = 17; n < 33; ++n) {
            this.item[n] = -1;
        }
    }

    synchronized void newSort(int n) {
        if (this.state == 4) {
            this.stopRunning();
        }
        this.state = 1;
        this.setUpSortData();
        this.comparisons.setText("0");
        this.copies.setText("0");
        this.comparisonCt = 0;
        this.copyCt = 0;
        this.method = n;
        this.valid = false;
        this.comment1.changeMessage("Click \"Go\" or \"Step\" to begin sorting.");
        this.comment2.changeMessage("");
        this.setChangedAll();
        this.repaint();
    }

    public synchronized void paint(Graphics graphics) {
        if (this.OSC == null || this.size().width != this.width || this.size().height != this.height) {
            try {
                this.OSC = this.createImage(this.size().width, this.size().height);
                this.OSG = this.OSC.getGraphics();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.OSC = null;
                this.OSG = null;
            }
            this.font = new Font("Helvetica", 0, 10);
            this.fm = graphics.getFontMetrics(this.font);
            if (this.OSG != null) {
                this.OSG.setFont(this.font);
            }
            this.textAscent = this.fm.getAscent();
            this.setSizeData(this.size().width, this.size().height);
            this.setChanged(0, 0, this.width, this.height);
        }
        if (this.OSC == null) {
            graphics.setFont(this.font);
            this.draw(graphics, 0, 0, this.width, this.height);
        } else {
            if (this.changed) {
                this.draw(this.OSG, this.changed_x, this.changed_y, this.changed_width, this.changed_height);
            }
            graphics.drawImage(this.OSC, 0, 0, this);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    void setSizeData(int n, int n2) {
        this.width = n;
        this.height = n2;
        int n3 = (this.width - 20 + 8) / 16;
        this.barWidth = n3 - 8;
        this.leftOffset = (this.width - 16 * this.barWidth - 120) / 2;
        this.barHeight = (this.height - 40 - 2 * this.textAscent) / 2;
        this.barIncrement = (this.barHeight - 3) / 17;
        this.minBarHeight = this.barHeight - 17 * this.barIncrement;
        this.firstRow_y = this.barHeight + 10;
        this.secondRow_y = 2 * this.barHeight + 25 + this.textAscent;
    }

    synchronized void setChanged(int n, int n2, int n3, int n4) {
        if (this.changed) {
            int n5 = Math.min(n, this.changed_x);
            int n6 = Math.min(n2, this.changed_y);
            int n7 = Math.max(n + n3, this.changed_x + this.changed_width);
            int n8 = Math.max(n2 + n4, this.changed_y + this.changed_height);
            this.changed_x = n5;
            this.changed_y = n6;
            this.changed_width = n7 - n5;
            this.changed_height = n8 - n6;
        } else {
            this.changed_x = n;
            this.changed_y = n2;
            this.changed_width = n3;
            this.changed_height = n4;
        }
        this.changed = true;
    }

    void setChangedAll() {
        this.setChanged(0, 0, this.size().width, this.size().height);
    }

    void putItem(Graphics graphics, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = this.item[n];
        if (n5 == -1) {
            return;
        }
        if (n5 > 16) {
            n4 = (n5 - 100) * this.barIncrement + this.minBarHeight;
            graphics.setColor(finishedBarColor);
        } else {
            n4 = n5 * this.barIncrement + this.minBarHeight;
            graphics.setColor(barColor);
        }
        if (n == 0) {
            n3 = this.leftOffset + (this.barWidth + 8) * 15 / 2;
            n2 = this.secondRow_y - n4;
        } else if (n < 17) {
            n3 = this.leftOffset + (n - 1) * (this.barWidth + 8);
            n2 = this.firstRow_y - n4;
        } else {
            n3 = this.leftOffset + (n - 17) * (this.barWidth + 8);
            n2 = this.secondRow_y - n4;
        }
        graphics.fillRect(n3, n2, this.barWidth, n4);
        graphics.setColor(finishedBarColor);
        graphics.drawRect(n3, n2, this.barWidth, n4);
    }

    void drawMovingItem(Graphics graphics) {
        int n = this.movingItem * this.barIncrement + this.minBarHeight;
        graphics.setColor(movingBarColor);
        graphics.fillRect(this.movingItemLoc.x, this.movingItemLoc.y - n, this.barWidth, n);
        graphics.setColor(movingBarOutlineColor);
        graphics.drawRect(this.movingItemLoc.x, this.movingItemLoc.y - n, this.barWidth, n);
    }

    void drawMax(Graphics graphics) {
        int n = this.fm.stringWidth("Max");
        int n2 = this.leftOffset + (this.maxLoc - 1) * (this.barWidth + 8) + this.barWidth / 2;
        int n3 = this.firstRow_y + 38 + this.textAscent;
        graphics.setColor(maxColor);
        graphics.drawString("Max", n2 - n / 2, n3 + this.textAscent);
        graphics.drawLine(n2, n3, n2, n3 - 30);
        graphics.drawLine(n2, n3 - 30, n2 + 6, n3 - 24);
        graphics.drawLine(n2, n3 - 30, n2 - 6, n3 - 24);
    }

    void drawBox(Graphics graphics, int n) {
        int n2;
        int n3;
        if (n == 0) {
            n3 = this.leftOffset + (this.barWidth + 8) * 15 / 2;
            n2 = this.secondRow_y;
        } else if (n < 17) {
            n3 = this.leftOffset + (n - 1) * (this.barWidth + 8);
            n2 = this.firstRow_y;
        } else {
            n3 = this.leftOffset + (n - 17) * (this.barWidth + 8);
            n2 = this.secondRow_y;
        }
        graphics.setColor(boxColor);
        graphics.drawRect(n3 - 2, n2 - this.barHeight - 2, this.barWidth + 4, this.barHeight + 4);
    }

    void drawMultiBox(Graphics graphics) {
        int n;
        int n2;
        if (this.multiBoxLoc.x < 17) {
            n2 = this.firstRow_y;
            n = this.leftOffset + (this.multiBoxLoc.x - 1) * (this.barWidth + 8);
        } else {
            n2 = this.secondRow_y;
            n = this.leftOffset + (this.multiBoxLoc.x - 17) * (this.barWidth + 8);
        }
        int n3 = (this.multiBoxLoc.y - this.multiBoxLoc.x) * (8 + this.barWidth) + this.barWidth;
        graphics.setColor(multiBoxColor);
        graphics.drawRect(n - 4, n2 - this.barHeight - 4, n3 + 8, this.barHeight + 8);
    }

    void drawMergeListBoxes(Graphics graphics) {
        int n = this.firstRow_y;
        int n2 = this.leftOffset + (this.mergeBox[0] - 1) * (this.barWidth + 8);
        int n3 = (this.mergeBox[1] - this.mergeBox[0]) * (8 + this.barWidth) + this.barWidth;
        int n4 = (this.mergeBox[2] - this.mergeBox[0]) * (8 + this.barWidth) + this.barWidth;
        graphics.setColor(multiBoxColor);
        graphics.drawRect(n2 - 4, n - this.barHeight - 4, n3 + 8, this.barHeight + 8);
        graphics.drawRect(n2 - 4, n - this.barHeight - 4, n4 + 8, this.barHeight + 8);
    }

    synchronized void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        graphics.setColor(backgroundColor);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(borderColor);
        graphics.drawRect(0, 0, this.width, this.height);
        graphics.drawRect(1, 1, this.width - 2, this.height - 2);
        graphics.drawLine(0, this.height - 2, this.width, this.height - 2);
        graphics.drawLine(this.width - 2, 0, this.width - 2, this.height);
        int n7 = (n - 10) / (this.barWidth + 8) + 1;
        if (n7 < 1) {
            n7 = 1;
        }
        if ((n6 = (n + n3 - 10) / (this.barWidth + 8) + 1) > 16) {
            n6 = 16;
        }
        if (n2 <= this.firstRow_y) {
            for (n5 = n7; n5 <= n6; ++n5) {
                this.putItem(graphics, n5);
            }
        }
        if (n2 <= this.firstRow_y + 10 + this.textAscent && n2 + n4 > this.firstRow_y) {
            graphics.setColor(borderColor);
            for (n5 = n7; n5 <= n6; ++n5) {
                String string = String.valueOf(n5);
                int n8 = this.fm.stringWidth(string);
                graphics.drawString(string, this.leftOffset + (n5 - 1) * (this.barWidth + 8) + (this.barWidth - n8) / 2, this.firstRow_y + 6 + this.textAscent);
            }
        }
        if (n2 <= this.secondRow_y && n2 + n4 >= this.secondRow_y - this.barHeight) {
            for (n5 = 16 + n7; n5 <= 16 + n6; ++n5) {
                this.putItem(graphics, n5);
            }
        }
        if (this.tempOn) {
            graphics.setColor(borderColor);
            n5 = this.fm.stringWidth("Temp");
            graphics.drawString("Temp", this.leftOffset + (16 * this.barWidth + 120 - n5) / 2, this.secondRow_y + 5 + this.textAscent);
            this.putItem(graphics, 0);
        }
        if (this.maxLoc >= 0) {
            this.drawMax(graphics);
        }
        if (this.box1Loc >= 0) {
            this.drawBox(graphics, this.box1Loc);
        }
        if (this.box2Loc >= 0) {
            this.drawBox(graphics, this.box2Loc);
        }
        if (this.multiBoxLoc.x > 0) {
            this.drawMultiBox(graphics);
        }
        if (this.mergeBox[0] > 0) {
            this.drawMergeListBoxes(graphics);
        }
        if (this.movingItem >= 0) {
            this.drawMovingItem(graphics);
        }
        this.changed = false;
    }

    synchronized void startRunning() {
        if (this.state == 0) {
            this.newSort(this.method);
        }
        this.state = 4;
        if (this.fast) {
            this.comment2.changeMessage("");
        }
        if (this.runner == null || !this.runner.isAlive()) {
            this.runner = new Thread(this);
            this.runner.start();
        } else {
            this.notify();
        }
    }

    synchronized void stopRunning() {
        if (this.runner != null && this.runner.isAlive() && this.state == 4) {
            this.state = 5;
            this.notify();
            while (this.state == 5) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    synchronized void setFast(boolean bl) {
        this.fast = bl;
        if (this.state == 4 && bl) {
            this.comment2.changeMessage("");
        }
        this.notify();
    }

    synchronized void doStep() {
        if (this.state == 4 || this.state == 0) {
            return;
        }
        this.state = 3;
        if (this.runner == null || !this.runner.isAlive()) {
            this.runner = new Thread(this);
            this.runner.start();
        } else {
            this.notify();
        }
    }

    synchronized void doAppletStop() {
        this.oldState = this.state;
        this.stopRunning();
        this.state = -1;
        this.OSC = null;
        this.OSG = null;
    }

    synchronized void doAppletStart() {
        if (this.state != -1) {
            return;
        }
        this.state = this.oldState;
        if (this.state == 4 || this.state == 3) {
            this.notify();
        }
    }

    synchronized void doWait(int n) {
        try {
            this.wait(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            int n;
            SortCanvas sortCanvas = this;
            synchronized (sortCanvas) {
                while (this.state <= 2) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                n = this.state;
            }
            if (n == 5) {
                this.setState(2);
                this.owner.runnerStopped();
                continue;
            }
            this.scriptStep();
            this.repaint();
            if (this.done) {
                this.owner.doneRunning(this.method, this.comparisonCt, this.copyCt);
                this.setState(0);
                this.repaint();
                continue;
            }
            if (this.getState() == 5) {
                this.setState(2);
                this.owner.runnerStopped();
                continue;
            }
            if (n == 3 && this.getState() != 4) {
                this.setState(2);
                this.owner.runnerStopped();
                continue;
            }
            if (this.fast) {
                this.doWait(100);
                continue;
            }
            this.doWait(1000);
        }
    }

    void say1(String string) {
        this.comment1.changeMessage(string);
    }

    void say2(String string) {
        if (!this.fast || this.getState() != 4) {
            this.comment2.changeMessage(string);
        }
    }

    void invalidate(int n, int n2) {
        int n3;
        int n4;
        if (n < 0) {
            return;
        }
        if (n == 0) {
            n4 = this.leftOffset + (this.barWidth + 8) * 15 / 2;
            n3 = this.secondRow_y - this.barHeight;
        } else if (n < 17) {
            n4 = this.leftOffset + (n - 1) * (this.barWidth + 8);
            n3 = this.firstRow_y - this.barHeight;
        } else {
            n4 = this.leftOffset + (n - 17) * (this.barWidth + 8);
            n3 = this.secondRow_y - this.barHeight;
        }
        this.setChanged(n4 - n2, n3 - n2, this.barWidth + 1 + 2 * n2, this.barHeight + 1 + 2 * n2);
    }

    void putTemp(boolean bl) {
        if (this.tempOn == bl) {
            return;
        }
        this.tempOn = bl;
        this.setChanged(0, this.secondRow_y + 1, this.width, this.height - this.secondRow_y);
    }

    void putMax(int n) {
        int n2 = this.fm.stringWidth("Max") + 4;
        if (this.maxLoc != -1) {
            this.setChanged(this.leftOffset + (this.maxLoc - 1) * (this.barWidth + 8) + (this.barWidth - n2) / 2, this.firstRow_y + 1, n2, 50 + this.textAscent);
        }
        this.maxLoc = n;
        if (this.maxLoc != -1) {
            this.setChanged(this.leftOffset + (this.maxLoc - 1) * (this.barWidth + 8) + (this.barWidth - n2) / 2, this.firstRow_y + 1, n2, 50 + this.textAscent);
        }
    }

    void putMergeListBoxes(int n, int n2, int n3) {
        if (this.mergeBox[0] != -1) {
            this.invalidate(this.mergeBox[0], 5);
            this.invalidate(this.mergeBox[2], 5);
        }
        this.mergeBox[0] = n;
        this.mergeBox[1] = n2;
        this.mergeBox[2] = n3;
        if (this.mergeBox[0] != -1) {
            this.invalidate(this.mergeBox[0], 5);
            this.invalidate(this.mergeBox[2], 5);
        }
    }

    void putMultiBox(int n, int n2) {
        if (this.multiBoxLoc.x != -1) {
            this.invalidate(this.multiBoxLoc.x, 5);
            this.invalidate(this.multiBoxLoc.y, 5);
        }
        this.multiBoxLoc.x = n;
        this.multiBoxLoc.y = n2;
        if (this.multiBoxLoc.x != -1) {
            this.invalidate(this.multiBoxLoc.x, 5);
            this.invalidate(this.multiBoxLoc.y, 5);
        }
    }

    void putBoxes(int n, int n2) {
        if (this.box1Loc != -1) {
            this.invalidate(this.box1Loc, 3);
        }
        this.box1Loc = n;
        if (this.box1Loc != -1) {
            this.invalidate(this.box1Loc, 3);
        }
        if (this.box2Loc != -1) {
            this.invalidate(this.box2Loc, 3);
        }
        this.box2Loc = n2;
        if (this.box2Loc != -1) {
            this.invalidate(this.box2Loc, 3);
            this.repaint();
            if (this.fast) {
                this.doWait(100);
            } else {
                this.doWait(200);
            }
        }
    }

    void itemChanged(int n) {
        this.invalidate(n, 0);
        this.repaint();
    }

    void copyFast(int n, int n2) {
        this.item[n] = this.item[n2];
        this.item[n2] = -1;
        this.invalidate(n, 0);
        this.invalidate(n2, 0);
        this.repaint();
        ++this.copyCt;
        this.copies.setText(String.valueOf(this.copyCt));
        this.doWait(100);
    }

    void copyItem(int n, int n2) {
        if (this.fast) {
            this.copyFast(n, n2);
        } else {
            int n3;
            int n4;
            int n5;
            int n6;
            this.movingItem = this.item[n2];
            this.item[n2] = -1;
            this.invalidate(n2, 0);
            if (n == 0) {
                n6 = this.leftOffset + (this.barWidth + 8) * 15 / 2;
                n5 = this.secondRow_y;
            } else if (n < 17) {
                n6 = this.leftOffset + (n - 1) * (this.barWidth + 8);
                n5 = this.firstRow_y;
            } else {
                n6 = this.leftOffset + (n - 17) * (this.barWidth + 8);
                n5 = this.secondRow_y;
            }
            if (n2 == 0) {
                n4 = this.leftOffset + (this.barWidth + 8) * 15 / 2;
                n3 = this.secondRow_y;
            } else if (n2 < 17) {
                n4 = this.leftOffset + (n2 - 1) * (this.barWidth + 8);
                n3 = this.firstRow_y;
            } else {
                n4 = this.leftOffset + (n2 - 17) * (this.barWidth + 8);
                n3 = this.secondRow_y;
            }
            int n7 = (int)Math.sqrt((n4 - n6) * (n4 - n6) + (n3 - n5) * (n3 - n5));
            int n8 = n7 / 5;
            if (n8 > 15) {
                n8 = 15;
            } else if (n8 < 5) {
                n8 = 5;
            }
            int n9 = this.minBarHeight + this.movingItem * this.barIncrement;
            for (int i = 0; i <= n8; ++i) {
                if (i > 0) {
                    this.setChanged(this.movingItemLoc.x, this.movingItemLoc.y - n9, this.barWidth + 1, n9 + 1);
                }
                this.movingItemLoc.x = n4 + (n6 - n4) * i / n8;
                this.movingItemLoc.y = n3 + (n5 - n3) * i / n8;
                this.setChanged(this.movingItemLoc.x, this.movingItemLoc.y - n9, this.barWidth + 1, n9 + 1);
                this.repaint();
                this.doWait(50);
            }
            this.item[n] = this.movingItem;
            this.movingItem = -1;
            this.invalidate(n, 0);
            this.repaint();
            this.doWait(50);
            ++this.copyCt;
            this.copies.setText(String.valueOf(this.copyCt));
        }
    }

    boolean greaterThan(int n, int n2) {
        this.putBoxes(n, n2);
        ++this.comparisonCt;
        this.comparisons.setText(String.valueOf(this.comparisonCt));
        return this.item[n] > this.item[n2];
    }

    void swapItems(int n, int n2) {
        this.copyItem(0, n);
        if (this.getState() == 1) {
            return;
        }
        this.copyItem(n, n2);
        if (this.getState() == 1) {
            return;
        }
        this.copyItem(n2, 0);
    }

    synchronized void scriptSetup() {
        this.comment2.changeMessage("");
        switch (this.method) {
            case 1: {
                this.j = 16;
                this.i = 1;
                this.say1("Phase 1:  largest item \"bubbles\" up to position 16");
                this.putTemp(true);
                break;
            }
            case 2: {
                this.j = 16;
                this.i = 2;
                this.say1("Phase 1:  Find the largest item and swap it with item 16");
                this.say2("Item 1 is the largest item seen so far during this phase");
                this.putMax(1);
                this.putTemp(true);
                break;
            }
            case 3: {
                this.j = 0;
                this.putMultiBox(1, 1);
                this.say1("The sublist in the box -- just item 1 for now -- is correctly sorted");
                break;
            }
            case 4: {
                this.sortLength = 1;
                this.i = 1;
                this.end_i = 1;
                this.j = 2;
                this.end_j = 2;
                this.k = 17;
                this.lo = 0;
                this.hi = 1;
                this.say1("Phase 1:  Merge lists of length 1 into lists of length 2");
                this.say2("First, merge item 1 with item 2.");
                this.putMultiBox(17, 18);
                this.putMergeListBoxes(1, 1, 2);
                break;
            }
            case 5: {
                this.top = 0;
                this.hi = 16;
                this.lo = 1;
                this.k = 0;
                this.i = 1;
                this.j = 16;
                this.say1("Apply \"QuickSortStep\" to items 1 through 16.");
                this.say2("The range of possible final positions for item 1 is boxed.");
                this.putMultiBox(1, 16);
                this.putTemp(true);
            }
        }
    }

    synchronized void scriptStep() {
        if (!this.valid) {
            this.scriptSetup();
            this.valid = true;
            this.done = false;
            return;
        }
        switch (this.method) {
            case 1: {
                if (this.i == this.j) {
                    this.comment2.changeMessage("");
                    this.putBoxes(-1, -1);
                    if (this.j == 2) {
                        this.say1("The sort is finished.");
                        this.done = true;
                        this.putTemp(false);
                        this.item[1] = 100 + this.item[1];
                        this.itemChanged(1);
                        break;
                    }
                    --this.j;
                    this.i = 1;
                    this.say1("Phase " + (17 - this.j) + ":  next largest item bubbles up to position " + this.j);
                    break;
                }
                if (this.greaterThan(this.i, this.i + 1)) {
                    this.say2("Is item " + this.i + " bigger than item " + (this.i + 1) + "?  Yes, so swap them.");
                    this.swapItems(this.i, this.i + 1);
                } else {
                    this.say2("Is item " + this.i + " bigger than item " + (this.i + 1) + "?  No, so don't swap them.");
                }
                ++this.i;
                if (this.i != this.j) break;
                this.item[this.j] = 100 + this.item[this.j];
                this.itemChanged(this.j);
                break;
            }
            case 2: {
                if (this.j == 1) {
                    this.say1("The sort is finished.");
                    this.comment2.changeMessage("");
                    this.done = true;
                    this.item[1] = 100 + this.item[1];
                    this.itemChanged(1);
                    this.putTemp(false);
                    break;
                }
                if (this.i == -1) {
                    this.say1("Phase " + (17 - this.j) + ":   Find the next largest item and move it to position " + this.j);
                    this.say2("Item 1 is the largest item seen so far during this phase");
                    this.i = 2;
                    this.putMax(1);
                    break;
                }
                if (this.i > this.j) {
                    this.putBoxes(-1, -1);
                    this.k = this.maxLoc;
                    this.putMax(-1);
                    if (this.k == this.j) {
                        this.say2("Item " + this.j + " is already in its correct location.");
                    } else {
                        if (this.j == 2) {
                            this.say2("Swap item 2 with item 1");
                        } else {
                            this.say2("Swap item " + this.j + " with maximum among items 1 through " + (this.j - 1));
                        }
                        this.swapItems(this.k, this.j);
                    }
                    this.item[this.j] = 100 + this.item[this.j];
                    this.itemChanged(this.j);
                    --this.j;
                    this.i = -1;
                    break;
                }
                if (this.greaterThan(this.i, this.maxLoc)) {
                    this.say2("Item " + this.i + " is bigger than item " + this.maxLoc + ", so item " + this.i + " is now the max seen.");
                    this.putMax(this.i);
                    ++this.i;
                    break;
                }
                this.say2("Item " + this.i + " is smaller than item " + this.maxLoc + ", so item " + this.maxLoc + " is still the max seen.");
                ++this.i;
                break;
            }
            case 3: {
                if (this.j == 0) {
                    this.say1("Phase 1: Insert item 2 into its correct position in the sorted list.");
                    this.say2("Copy item 2 to Temp.");
                    this.copyItem(0, 2);
                    this.j = 2;
                    this.i = 1;
                    this.putTemp(true);
                    break;
                }
                if (this.j == 17) {
                    this.putMultiBox(-1, -1);
                    int n = 1;
                    while (n <= 16) {
                        int n2 = n++;
                        this.item[n2] = this.item[n2] + 100;
                    }
                    this.setChangedAll();
                    this.say1("The sort is finished.");
                    this.done = true;
                    this.comment2.changeMessage("");
                    this.putTemp(false);
                    break;
                }
                if (this.i == 0) {
                    this.say2("Temp is smaller than all items in the sorted list; copy it to position 1.");
                    this.copyItem(1, 0);
                    this.i = -1;
                    break;
                }
                if (this.i == -1) {
                    this.putBoxes(-1, -1);
                    this.say1("Items 1 through " + this.j + " now form a sorted list.");
                    this.comment2.changeMessage("");
                    this.putMultiBox(1, this.j);
                    ++this.j;
                    this.i = -2;
                    break;
                }
                if (this.i == -2) {
                    this.say1("Phase " + (this.j - 1) + ": Insert item " + this.j + "  into its correct position in the sorted list.");
                    this.say2("Copy item " + this.j + " to Temp.");
                    this.copyItem(0, this.j);
                    this.i = this.j - 1;
                    break;
                }
                if (this.greaterThan(this.i, 0)) {
                    this.say2("Is item " + this.i + " bigger than Temp?  Yes, so move it up to position " + (this.i + 1));
                    this.copyItem(this.i + 1, this.i);
                    --this.i;
                    break;
                }
                this.say2("Is item " + this.i + " bigger than Temp?  No, so Temp belongs in position " + (this.i + 1));
                this.copyItem(this.i + 1, 0);
                this.i = -1;
                break;
            }
            case 4: {
                if (this.lo == 1 && this.sortLength == 8) {
                    int n = 1;
                    while (n <= 16) {
                        int n3 = n++;
                        this.item[n3] = this.item[n3] + 100;
                    }
                    this.setChangedAll();
                    this.say1("The sort is finished.");
                    this.comment2.changeMessage("");
                    this.done = true;
                    break;
                }
                if (this.lo == 1) {
                    ++this.hi;
                    this.sortLength *= 2;
                    this.say1("Phase " + this.hi + ":  Merge lists of length " + this.sortLength + " into lists of length " + this.sortLength * 2);
                    this.k = 17;
                    this.i = 1;
                    this.j = this.sortLength + 1;
                    this.end_i = this.i + this.sortLength - 1;
                    this.end_j = this.j + this.sortLength - 1;
                    this.say2("First, merge items " + this.i + " through " + this.end_i + " with items " + this.j + " through " + this.end_j);
                    this.putMultiBox(this.i + 16, this.end_j + 16);
                    this.putMergeListBoxes(this.i, this.end_i, this.end_j);
                    this.lo = 0;
                    break;
                }
                if (this.end_i < this.i && this.end_j < this.j) {
                    if (this.k == 33) {
                        this.putMultiBox(-1, -1);
                        this.putMergeListBoxes(-1, -1, -1);
                        this.say2("Copy merged items back to original list.");
                        for (int i = 1; i < 17; ++i) {
                            this.copyFast(i, i + 16);
                            if (this.getState() != 1) continue;
                            return;
                        }
                        this.lo = 1;
                        break;
                    }
                    this.end_i += 2 * this.sortLength;
                    this.end_j += 2 * this.sortLength;
                    this.j = this.end_i + 1;
                    this.i = this.j - this.sortLength;
                    if (this.sortLength == 1) {
                        this.say2("Next, merge item " + this.i + " with item " + this.j);
                    } else {
                        this.say2("Next, merge items " + this.i + " through " + this.end_i + " with items " + this.j + " through " + this.end_j);
                    }
                    this.putMultiBox(this.i + 16, this.end_j + 16);
                    this.putMergeListBoxes(this.i, this.end_i, this.end_j);
                    break;
                }
                if (this.end_i < this.i) {
                    this.putBoxes(-1, -1);
                    this.say2("List 1 is empty; move item " + this.j + " to the merged list.");
                    this.copyItem(this.k, this.j);
                    ++this.j;
                    ++this.k;
                    break;
                }
                if (this.end_j < this.j) {
                    this.putBoxes(-1, -1);
                    this.say2("List 2 is empty; move item " + this.i + " to the merged list.");
                    this.copyItem(this.k, this.i);
                    ++this.i;
                    ++this.k;
                    break;
                }
                if (this.greaterThan(this.i, this.j)) {
                    this.say2("Is item " + this.j + " smaller than item " + this.i + "?  Yes, so move item " + this.j + " to merged list");
                    this.copyItem(this.k, this.j);
                    ++this.j;
                    ++this.k;
                    break;
                }
                this.say2("Is item " + this.j + " smaller than item " + this.i + "?  No, so move item " + this.i + " to merged list");
                this.copyItem(this.k, this.i);
                ++this.i;
                ++this.k;
                break;
            }
            case 5: {
                if (this.k == 0) {
                    if (this.hi == this.lo) {
                        this.say2("There is only one item in the range; it is already in its final position.");
                        this.item[this.hi] = 100 + this.item[this.hi];
                        this.itemChanged(this.hi);
                        this.putMultiBox(-1, -1);
                        this.k = 1;
                        break;
                    }
                    this.say2("Copy item " + this.lo + " to Temp");
                    this.copyItem(0, this.lo);
                    this.k = -1;
                    break;
                }
                if (this.k == 1) {
                    if (this.top == 0) {
                        this.say1("The sort is finished.");
                        this.comment2.changeMessage("");
                        this.putTemp(false);
                        this.done = true;
                        break;
                    }
                    this.hi = this.stack[this.top];
                    this.lo = this.stack[this.top - 1];
                    this.j = this.hi;
                    this.i = this.lo;
                    this.top -= 2;
                    this.say1("Apply \"QuickSortStep\" to items " + this.lo + " through " + this.hi);
                    this.say2("The range of possible final positions for item " + this.lo + " is boxed");
                    this.putMultiBox(this.lo, this.hi);
                    this.k = 0;
                    break;
                }
                if (this.k == 2) {
                    this.say2("Item " + this.hi + " is in final position; smaller items below and bigger items above");
                    this.putMultiBox(-1, -1);
                    this.item[this.hi] = 100 + this.item[this.hi];
                    this.itemChanged(this.hi);
                    if (this.hi < this.j) {
                        this.stack[this.top + 1] = this.hi + 1;
                        this.stack[this.top + 2] = this.j;
                        this.top += 2;
                    }
                    if (this.hi > this.i) {
                        this.stack[this.top + 1] = this.i;
                        this.stack[this.top + 2] = this.hi - 1;
                        this.top += 2;
                    }
                    this.k = 1;
                    break;
                }
                if (this.hi == this.lo) {
                    this.putBoxes(-1, -1);
                    this.say2("Only one possible position left for Temp; copy Temp to position " + this.hi);
                    this.copyItem(this.hi, 0);
                    this.k = 2;
                    break;
                }
                if (this.item[this.lo] == -1) {
                    if (this.greaterThan(0, this.hi)) {
                        this.say2("Item " + this.hi + " is smaller than Temp, so move it; Temp will end up above it");
                        this.copyItem(this.lo, this.hi);
                        ++this.lo;
                        this.putMultiBox(this.lo, this.hi);
                        break;
                    }
                    this.say2("Item " + this.hi + " is bigger than Temp, so Temp will end up below it");
                    --this.hi;
                    this.putMultiBox(this.lo, this.hi);
                    break;
                }
                if (this.item[this.hi] != -1) break;
                if (this.greaterThan(this.lo, 0)) {
                    this.say2("Item " + this.lo + " is bigger than Temp, so move it; Temp will end up below it");
                    this.copyItem(this.hi, this.lo);
                    --this.hi;
                    this.putMultiBox(this.lo, this.hi);
                    break;
                }
                this.say2("Item " + this.lo + " is smaller than Temp, so Temp will end up above it");
                ++this.lo;
                this.putMultiBox(this.lo, this.hi);
            }
        }
    }
}

