/*
 * Decompiled with CFR 0.152.
 */
package tmcm.xSortLab;

import java.awt.AWTError;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

class LogPanel
extends Panel {
    String saveContents;
    TextArea text;
    Button saveButton;
    Button clearButton;
    boolean hidden = true;
    String saveText = "";
    boolean canSave = true;
    boolean firstTime = true;
    String eoln = System.getProperty("line.separator");

    LogPanel() {
        this.setBackground(Color.lightGray);
        this.setLayout(new BorderLayout(5, 5));
        this.text = new TextArea();
        this.text.setEditable(false);
        this.add("Center", this.text);
        Panel panel = new Panel();
        panel.setBackground(Color.lightGray);
        this.add("South", panel);
        this.clearButton = new Button("Clear Log");
        panel.add(this.clearButton);
        this.saveButton = new Button("Save to File");
        panel.add(this.saveButton);
    }

    void addLine(String string) {
        if (this.hidden) {
            this.saveText = this.saveText + string + this.eoln;
        } else {
            this.clearMessage();
            this.text.appendText(string + this.eoln);
            this.text.select(32000, 32000);
        }
    }

    void addEoln() {
        if (this.hidden) {
            this.saveText = this.saveText + this.eoln;
        } else {
            this.clearMessage();
            this.text.appendText(this.eoln);
            this.text.select(32000, 32000);
        }
    }

    void setMessage(String string) {
        this.saveContents = this.text.getText();
        this.text.setText(string + this.eoln + this.eoln + "Click \"Clear Log\" button to dismiss this message.");
    }

    void clearMessage() {
        if (this.saveContents != null) {
            this.text.setText(this.saveContents);
            this.saveContents = null;
        }
    }

    void aboutToShow() {
        if (!this.firstTime) {
            this.text.setText(this.saveText);
            this.saveText = "";
        }
    }

    void shown() {
        if (this.firstTime) {
            this.text.setText(this.saveText);
            this.firstTime = false;
        }
    }

    void aboutToHide() {
        this.clearMessage();
        this.saveText = this.text.getText();
    }

    void doSave() {
        if (!this.canSave) {
            return;
        }
        String string = null;
        String string2 = null;
        try {
            Object object;
            Object object2;
            FileDialog fileDialog = null;
            try {
                object2 = this;
                while ((object = ((Component)object2).getParent()) != null) {
                    object2 = object;
                }
                if (!(object2 instanceof Frame)) {
                    object2 = null;
                }
                fileDialog = new FileDialog((Frame)object2, "Save as:", 1);
                fileDialog.show();
            }
            catch (AWTError aWTError) {
                this.setMessage("ERROR while trying to create a file dialog box." + this.eoln + "It will not be possible to save files.");
                this.canSave = false;
                this.saveButton.disable();
                return;
            }
            catch (RuntimeException runtimeException) {
                this.setMessage("ERROR while trying to create a file dialog box." + this.eoln + "It will not be possible to save files.");
                this.canSave = false;
                this.saveButton.disable();
                return;
            }
            string = fileDialog.getFile();
            if (string == null) {
                return;
            }
            string2 = fileDialog.getDirectory();
            object2 = new PrintStream(new FileOutputStream(new File(string2, string)));
            object = this.text.getText();
            ((PrintStream)object2).print((String)object);
            ((PrintStream)object2).close();
        }
        catch (IOException iOException) {
            this.setMessage("OUTPUT ERROR while trying to save to the file '" + string + "':  " + this.eoln + this.eoln + iOException.getMessage());
        }
        catch (SecurityException securityException) {
            this.setMessage("SECURITY ERROR while trying to save to the file '" + string + "':  " + this.eoln + this.eoln + securityException.getMessage());
        }
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.saveButton) {
            this.clearMessage();
            this.doSave();
            return true;
        }
        if (event.target == this.clearButton) {
            if (this.saveContents != null) {
                this.clearMessage();
            } else {
                this.text.setText("");
            }
            return true;
        }
        return super.action(event, object);
    }
}

